package cookbook.android.haptic.activity;

import android.app.Activity;
import android.os.Vibrator;
import android.view.HapticFeedbackConstants;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.widget.Button;
import android.widget.SeekBar;
import android.widget.TextView;
import cookbook.android.haptic.R;

public class MainActivity extends Activity {
    
    @Override
    protected void onStart() {
    	super.onStart();
    	setContentView( R.layout.main );
        initializeWidgets();
    }
       
    private void initializeWidgets() {
    	// intialize the buttons with the standard Haptic feedback options
    	initializeButton( R.id.btn_keyboardTap, HapticFeedbackConstants.KEYBOARD_TAP );
    	initializeButton( R.id.btn_longPress,   HapticFeedbackConstants.LONG_PRESS );
    	initializeButton( R.id.btn_virtualKey, HapticFeedbackConstants.VIRTUAL_KEY );
		SeekBar seekBar = (SeekBar) findViewById( R.id.vibrateDuration );
		seekBar.setOnSeekBarChangeListener( new DurationListener() );
		curDuration = ( TextView ) findViewById( R.id.currentDuration );
		Button customBtn = ( Button ) findViewById( R.id.btn_custom );
		customBtn.setOnTouchListener( new CustomHapticListener() );
    }
    
    private void initializeButton( int btnId, int hapticId ) {
    	Button keyboardTapBtn = ( Button ) findViewById( btnId );
    	keyboardTapBtn.setOnTouchListener( new HapticTouchListener( hapticId ) );    	
    }
    
    private class DurationListener implements SeekBar.OnSeekBarChangeListener {

		@Override
		public void onProgressChanged( SeekBar seeker, int progress, boolean fromUser ) {
			// set the text indicating the current postition on the seekbar
			curDuration.setText( progress + " milliseconds" );
			duration = progress;
		}

		@Override
		public void onStartTrackingTouch( SeekBar seeker ) { }

		@Override
		public void onStopTrackingTouch ( SeekBar seeker ) { }
    }
    
    private class CustomHapticListener implements OnTouchListener {

		@Override
		public boolean onTouch( View v, MotionEvent event ) {
			if( event.getAction() == MotionEvent.ACTION_DOWN ){
				Vibrator vibe = ( Vibrator ) getSystemService( VIBRATOR_SERVICE );
				vibe.vibrate( duration );
			}
			return true;
		}    	
    }
    
    private class HapticTouchListener implements OnTouchListener {

    	private final int feedbackType;
    	
    	public HapticTouchListener( int type ) { feedbackType = type; }
    	
    	public int feedbackType() { return feedbackType; }
    	
		@Override
		public boolean onTouch(View v, MotionEvent event) {
			if( event.getAction() == MotionEvent.ACTION_DOWN ){
				v.performHapticFeedback( feedbackType(), HapticFeedbackConstants.FLAG_IGNORE_GLOBAL_SETTING );
			}
			return true;
		}
    }
    
	private TextView curDuration;
	private int      duration;
}